using System;
using Server.Network;
using Server.Items;

namespace Server.Items
{
	public class WildfireBow : MagicalShortbow
	{
		public override int LabelNumber{ get{ return 1075044; } } // Wildfire Bow
		
		[Constructable]
		public WildfireBow() : base()
		{
			Hue = 1161;
         SkillBonuses.SetValues( 0, SkillName.Archery, 10.0 );
			WeaponAttributes.ResistFireBonus = 25;
		}
		
		public override void GetDamageTypes( Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy )
		{
			phys = cold = pois = nrgy = 0;
			fire = 100;
		}

		public WildfireBow( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
}